//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property description "Virtual Test..."
#property description "Demo version between interaction"
#property description "of Chart Trade and Expert Advisor"
#property version   "1.78"

//+------------------------------------------------------------------+
#include <Market Replay\Defines.mqh>
//+------------------------------------------------------------------+
class C_Decode
{
	private	:
		struct stInfoEvent
		{
			EnumEvents 	ev;
			string 		szSymbol;
			bool			IsDayTrade;
			ushort 		Leverange;
			double		PointsTake,
							PointsStop;
		}info[1];
	public	:
//+------------------------------------------------------------------+
		C_Decode()
			{
				info[0].szSymbol = _Symbol;
			}
//+------------------------------------------------------------------+	
		bool Decode(const int id, const string sparam)
		{
			string Res[];
		
			if (StringSplit(sparam, '?', Res) != 6) return false;
			stInfoEvent loc = {(EnumEvents) StringToInteger(Res[0]), Res[1], (bool)(Res[2] == "D"), (ushort) StringToInteger(Res[3]), StringToDouble(Res[4]), StringToDouble(Res[5])};
			if ((id == loc.ev) && (loc.szSymbol == info[0].szSymbol)) info[0] = loc;
			
			ArrayPrint(info, 2);
		
			return true;
		}
}*GL_Decode;
//+------------------------------------------------------------------+
int OnInit()
{
	GL_Decode = new C_Decode;
	
	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
void OnTick() {}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
	switch (id)
	{
		case CHARTEVENT_CUSTOM + evChartTradeBuy		:
		case CHARTEVENT_CUSTOM + evChartTradeSell		:
		case CHARTEVENT_CUSTOM + evChartTradeCloseAll:
			GL_Decode.Decode(id - CHARTEVENT_CUSTOM, sparam);
			break;
	}
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	delete GL_Decode;
}
//+------------------------------------------------------------------+
